package w83b.w83bOperacionesPaso.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bMantenimientos.w83bConvenios.W83bTablaConveniosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaActasExcelAction extends Q70ActionPasoOP{


	
	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	 
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoActas.xls";//NOPMD
		InputStream inputStream = W83bTablaConveniosExcelAction.class.getResourceAsStream(strRutaExcel);//NOPMD
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro//NOPMD
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja//NOPMD
        
        
        List listaActas = (ArrayList)contexto.get("w83bListaActas");//NOPMD
        W83bActasBean actasBean = (W83bActasBean)contexto.get("w83bActasTempBean");//NOPMD
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());        

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);

        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)3);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
            
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
       
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }            
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)3);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloActa_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloActa_es",idioma));
        cell.setCellValue(titulo.toString());
        
        //MAPEO FORMULARIO
        //NUMERO ACTA
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nActaDH"));
        cell = row.getCell(Short.parseShort("2"));        
        String nActaDesde = "";
        StringBuffer nActaHasta = new StringBuffer();
                
        
        boolean desde = false;
        
        if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioDesde())||
        		StringUtils.isNotEmpty(actasBean.getNumActaAnyoDesde())||
        		StringUtils.isNotEmpty(actasBean.getNumActaNumeroDesde())){
        	desde = true;
        }        
        
        if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioDesde())){
        	nActaDesde = actasBean.getNumActaTerritorioDesde();
        }else if(StringUtils.isNotEmpty(actasBean.getNumActaNumeroDesde())){
        	nActaDesde = "-";
        }
        if(!"".equals(nActaDesde)){
        	if(StringUtils.isNotEmpty(actasBean.getNumActaAnyoDesde())){
        		nActaDesde = nActaDesde + "/" +actasBean.getNumActaAnyoDesde();//NOPMD       		
        	}else{
        		nActaDesde = nActaDesde + "/-"; //NOPMD       		
        	}
        }else{
        	nActaDesde = actasBean.getNumActaAnyoDesde();      	
        }
        if(StringUtils.isNotEmpty(actasBean.getNumActaNumeroDesde())){
        	nActaDesde = nActaDesde + "/" +actasBean.getNumActaNumeroDesde(); //NOPMD       	
        }else if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioDesde())){
        	nActaDesde = nActaDesde + "/-"; //NOPMD       	
        }
        
        if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioHasta().toString())||
        		StringUtils.isNotEmpty(actasBean.getNumActaAnyoHasta().toString())||
        		StringUtils.isNotEmpty(actasBean.getNumActaNumeroHasta().toString())){
        	if(desde){
        		nActaHasta.append(" al ");
        	}
        }
         
        if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioHasta())){
        	nActaHasta.append(actasBean.getNumActaTerritorioHasta());
        }else if(StringUtils.isNotEmpty(actasBean.getNumActaNumeroHasta())){
        	nActaHasta.append("-");
        }
        if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioHasta())){
        	if(StringUtils.isNotEmpty(actasBean.getNumActaAnyoHasta())){
        		nActaHasta.append("/" +actasBean.getNumActaAnyoHasta());//NOPMD       		
        	}else{
        		nActaHasta.append("/-"); //NOPMD       		
        	}
        }else{
        	nActaHasta.append(actasBean.getNumActaAnyoHasta());      	
        }

        if(StringUtils.isNotEmpty(actasBean.getNumActaNumeroHasta())){
        	nActaHasta.append("/" +actasBean.getNumActaNumeroHasta()); //NOPMD       	
        }else if(StringUtils.isNotEmpty(actasBean.getNumActaTerritorioHasta())){
        	nActaHasta.append("/-"); //NOPMD       	
        }
      
        if(StringUtils.isNotEmpty(nActaDesde.toString())||StringUtils.isNotEmpty(nActaHasta.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(nActaDesde +nActaHasta );
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue(nActaDesde +nActaHasta );
        }
      //fin NUMERO ACTA
        
        //NUMERO REGISTRO DEFINITIVO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nRegDH"));
        cell = row.getCell(Short.parseShort("5"));        
        String nRegDesde = "";
        StringBuffer nRegHasta = new StringBuffer();
        

        
        
        desde = false;
        
        if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioDesde())||
        		StringUtils.isNotEmpty(actasBean.getNumRegAnyoDesde())||
        		StringUtils.isNotEmpty(actasBean.getNumRegNumeroDesde())){
        	desde = true;
        }        
        
        if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioDesde())){
        	nRegDesde = actasBean.getNumRegTerritorioDesde();
        }else if(StringUtils.isNotEmpty(actasBean.getNumRegNumeroDesde())){
        	nRegDesde = "-";
        }
        
        if(!"".equals(nRegDesde)){
        	if(StringUtils.isNotEmpty(actasBean.getNumRegAnyoDesde())){
        		nRegDesde = nRegDesde + "/" +actasBean.getNumRegAnyoDesde();//NOPMD       		
        	}else{
        		nRegDesde = nRegDesde + "/-"; //NOPMD       		
        	}
        }else{
        	nRegDesde = actasBean.getNumRegAnyoDesde();      	
        }
        if(StringUtils.isNotEmpty(actasBean.getNumRegNumeroDesde())){
        	nRegDesde = nRegDesde + "/" +actasBean.getNumRegNumeroDesde(); //NOPMD       	
        }else if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioDesde())){
        	nRegDesde = nRegDesde + "/-"; //NOPMD       	
        }
        
        if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioHasta().toString())||
        		StringUtils.isNotEmpty(actasBean.getNumRegAnyoHasta().toString())||
        		StringUtils.isNotEmpty(actasBean.getNumRegNumeroHasta().toString())){
        	if(desde){
        		nRegHasta.append(" al ");
        	}
        }
        
        if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioHasta())){
        	nRegHasta.append(actasBean.getNumRegTerritorioHasta());
        }else if(StringUtils.isNotEmpty(actasBean.getNumRegNumeroHasta())){
        	nRegHasta.append("-");
        }
        
        if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioHasta())){
        	if(StringUtils.isNotEmpty(actasBean.getNumRegAnyoHasta())){
        		nRegHasta.append("/" +actasBean.getNumRegAnyoHasta());//NOPMD       		
        	}else{
        		nRegHasta.append("/-"); //NOPMD       		
        	}
        }else{
        	nRegHasta.append(actasBean.getNumRegAnyoHasta());      	
        }
        if(StringUtils.isNotEmpty(actasBean.getNumRegNumeroHasta())){
        	nRegHasta.append("/" +actasBean.getNumRegNumeroHasta()); //NOPMD       	
        }else if(StringUtils.isNotEmpty(actasBean.getNumRegTerritorioHasta())){
        	nRegHasta.append("/-"); //NOPMD       	
        }
      
        if(StringUtils.isNotEmpty(nRegDesde.toString())||StringUtils.isNotEmpty(nRegHasta.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("5"),W83bClsConstantes.DOCE,Short.parseShort("6")));//NOPMD
        	cell.setCellValue(nRegDesde+nRegHasta);
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("7")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.sinregdef"));
        cell = row.getCell(Short.parseShort("8"));        
        
        String sinRegistro = "";
        
        if(StringUtils.isNotEmpty(actasBean.getSinRegDefinitivo())){
        	sinRegistro = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }else{
        	sinRegistro = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();        	
        }        
        cell.setCellValue(sinRegistro);
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        //fin NUMERO REGISTRO DEFINITIVO        
        

        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.cif"));
        cell = row.getCell(Short.parseShort("2"));        
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getCifnif())||StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getNumCentro())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("2"),W83bClsConstantes.TRECE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(actasBean.getCentroTrabajo().getCifnif()+ " "+ actasBean.getCentroTrabajo().getNumCentro());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.rSocial"));
        cell = row.getCell(Short.parseShort("5"));        
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getRazonSocial())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("5"),W83bClsConstantes.TRECE,Short.parseShort("9")));//NOPMD
        	cell.setCellValue(actasBean.getCentroTrabajo().getRazonSocial().toUpperCase()); 
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue(actasBean.getCentroTrabajo().getRazonSocial());
        }
        row = sheet.getRow(Short.parseShort("14")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.provabr"));
        cell = row.getCell(Short.parseShort("2"));        
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getTerritorio())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("2"),W83bClsConstantes.CATORCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(actasBean.getCentroTrabajo().getTerritorio().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.municipio"));
        cell = row.getCell(Short.parseShort("5"));        
        if(StringUtils.isNotEmpty(actasBean.getCentroTrabajo().getMunicipio())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("5"),W83bClsConstantes.CATORCE,Short.parseShort("8")));//NOPMD
        	cell.setCellValue(actasBean.getCentroTrabajo().getMunicipio().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue(actasBean.getCentroTrabajo().getMunicipio());
        }
        //fin CENTRO TRABAJO        
        
        //N de Registro        
        row = sheet.getRow(Short.parseShort("15")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nPre"));
        cell = row.getCell(Short.parseShort("2")); 
        
        String nPreaviso = "";
        if(StringUtils.isNotEmpty(actasBean.getTerritorioPreaviso())&&
        		StringUtils.isNotEmpty(actasBean.getAnyoPreaviso())&&
        		StringUtils.isNotEmpty(actasBean.getNumPreaviso())){
        	nPreaviso = actasBean.getTerritorioPreaviso() + "/" +actasBean.getAnyoPreaviso() + "/" +actasBean.getNumPreaviso();
        } 
        if(StringUtils.isNotEmpty(nPreaviso)){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE,Short.parseShort("2"),W83bClsConstantes.QUINCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(nPreaviso);
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.QUINCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.actaP"));
        cell = row.getCell(Short.parseShort("5"));        
        if(StringUtils.isNotEmpty(actasBean.getActaparcial())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        }
        //fin N de Registro   
        
        //FECHA DE ENTRADA
        row = sheet.getRow(Short.parseShort("16")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fEntraDH"));
        cell = row.getCell(Short.parseShort("2"));        

        StringBuffer fechaEntrada = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(actasBean.getFechaEntradaDel())){
        	fechaEntrada.append(actasBean.getFechaEntradaDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(actasBean.getFechaEntradaHasta())){
        	if(desde){
        		fechaEntrada.append("-");
        	}
        	fechaEntrada.append(actasBean.getFechaEntradaHasta());
        }
        if(StringUtils.isNotEmpty(fechaEntrada.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS,Short.parseShort("2"),W83bClsConstantes.DIECISEIS,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(fechaEntrada.toString());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISEIS,excel,wb));
        }else{
        	cell.setCellValue("");
        }
      //fin FECHA DE ENTRADA        
        //FECHA DE COMISIN
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fComisDH"));
        cell = row.getCell(Short.parseShort("5"));        
        
        StringBuffer fechaComision = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(actasBean.getFechaComisionDel())){
        	fechaComision.append(actasBean.getFechaComisionDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(actasBean.getFechaComisionHasta())){
        	if(desde){
        		fechaComision.append("-");
        	}
        	fechaComision.append(actasBean.getFechaComisionHasta());
        }
        if(StringUtils.isNotEmpty(fechaComision.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS,Short.parseShort("5"),W83bClsConstantes.DIECISEIS,Short.parseShort("6")));//NOPMD
        	cell.setCellValue(fechaComision.toString());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISEIS,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("7")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.sinFComision"));
        cell = row.getCell(Short.parseShort("8"));        
        
        String sinComision = "";
        
        if(W83bClsConstantes.CONSTANTE_SI.equals(actasBean.getSinFechaComision())){
        	sinComision = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else {
        	sinComision = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);        	
        }        
        cell.setCellValue(sinComision.toUpperCase()); 
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISEIS,excel,wb));
        //fin FECHA DE COMISIN
        
        //FECHA DE ELECCIN
        row = sheet.getRow(Short.parseShort("17")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fElecDH"));
        cell = row.getCell(Short.parseShort("2"));        

        StringBuffer fechaEleccion = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(actasBean.getFechaEleccionDel())){
        	fechaEleccion.append(actasBean.getFechaEleccionDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(actasBean.getFechaEleccionHasta())){
        	if(desde){
        		fechaEleccion.append("-");
        	}
        	fechaEleccion.append(actasBean.getFechaEleccionHasta());
        }
        if(StringUtils.isNotEmpty(fechaEleccion.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE,Short.parseShort("2"),W83bClsConstantes.DIECISIETE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(fechaEleccion.toString());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISIETE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
      //fin FECHA DE ELECCIN  
        //N DE TRABAJADORES

        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nElecDH"));
        cell = row.getCell(Short.parseShort("5"));        
        
        StringBuffer nElectores = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(actasBean.getNumElectoresDesde())){
        	nElectores.append(actasBean.getNumElectoresDesde());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(actasBean.getNumElectoresHasta())){
        	if(desde){
        		nElectores.append(nElectores).append("-");
        	}
        	nElectores.append(actasBean.getNumElectoresHasta());
        }
        if(StringUtils.isNotEmpty(nElectores.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE,Short.parseShort("5"),W83bClsConstantes.DIECISIETE,Short.parseShort("6")));//NOPMD
        	cell.setCellValue(nElectores.toString());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISIETE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        //fin N DE TRABAJADORES
        //ACTAS DE BAJA
        row = sheet.getRow(Short.parseShort("18")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fBajaDH"));
        cell = row.getCell(Short.parseShort("2"));        
        
        StringBuffer fActasBaja = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(actasBean.getFechaBajaDel())){
        	fActasBaja.append(actasBean.getFechaBajaDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(actasBean.getFechaBajaHasta())){
        	if(desde){
        		fActasBaja.append("-");
        	}
        	fActasBaja.append(actasBean.getFechaBajaHasta());
        }
        if(StringUtils.isNotEmpty(fActasBaja.toString())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO,Short.parseShort("2"),W83bClsConstantes.DIECIOCHO,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(fActasBaja.toString());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECIOCHO,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        row = sheet.getRow(Short.parseShort("18")); 
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.motivoBaja"));
        cell = row.getCell(Short.parseShort("5"));        
        if(StringUtils.isNotEmpty(actasBean.getMotivoBajaTxt())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO,Short.parseShort("5"),W83bClsConstantes.DIECIOCHO,Short.parseShort("8")));//NOPMD
        	cell.setCellValue(actasBean.getMotivoBajaTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECIOCHO,excel,wb));
        }else{
        	cell.setCellValue(actasBean.getMotivoBajaTxt());
        }
        //fin ACTAS DE BAJA
        //CONVENIOS
        row = sheet.getRow(Short.parseShort("19")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.convenioabr"));
        cell = row.getCell(Short.parseShort("2"));        
        if(StringUtils.isNotEmpty(actasBean.getConvenioTxt())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE,Short.parseShort("2"),W83bClsConstantes.DIEZYNUEVE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(actasBean.getConvenioTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIEZYNUEVE,excel,wb));
        }else{
        	cell.setCellValue(actasBean.getConvenioTxt());
        }
        int tamanyoConvenio = actasBean.getConvenioTxt().length();
        if(30<tamanyoConvenio&&(short)(22*(tamanyoConvenio/30)+1)<(short)(22*(tamanyoConvenio/24)+1)){
        	row.setHeightInPoints((short)(20*(tamanyoConvenio/24)+1));
        }
        
        row = sheet.getRow(Short.parseShort("19")); 
        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.inspec"));
        cell = row.getCell(Short.parseShort("5")); 
        String inspecciones = "";
        
        if(W83bClsConstantes.CONSTANTE_VALIDADA.equals(actasBean.getInspecciones())){
        	inspecciones = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else if(W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(actasBean.getInspecciones())){
        	inspecciones = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);        	
        }    
        else{
        	inspecciones = "";
        }
        cell.setCellValue(inspecciones.toUpperCase());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIEZYNUEVE,excel,wb));
        
        cell = row.getCell(Short.parseShort("7")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.tActa"));
        cell = row.getCell(Short.parseShort("8")); 
        String tipoActa = "";
        
        if(W83bClsConstantes.TIPO_ACTA_PARCIALES.equals(actasBean.getTipoActa())){
        	tipoActa = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.parciales",idioma);
        }else if(W83bClsConstantes.TIPO_ACTA_TOTALES.equals(actasBean.getTipoActa())){
        	tipoActa = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.totales",idioma);        	
        }
        if(StringUtils.isNotEmpty(tipoActa)){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE,Short.parseShort("8"),W83bClsConstantes.DIEZYNUEVE,Short.parseShort("9")));//NOPMD
        }
        cell.setCellValue(tipoActa.toUpperCase());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIEZYNUEVE,excel,wb));
        
        //TRMITE
        int tamanyoTexto = 0;
        row = sheet.getRow(Short.parseShort("20")); 
        cell = row.getCell(Short.parseShort("1")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fase"));
        cell = row.getCell(Short.parseShort("2"));
        if(StringUtils.isNotEmpty(actasBean.getFaseTxt())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE,Short.parseShort("2"),W83bClsConstantes.VEINTE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(actasBean.getFaseTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.VEINTE,excel,wb));
        }else{
        	cell.setCellValue(actasBean.getFaseTxt());
        }
        tamanyoTexto = actasBean.getFaseTxt().length();
        if(30<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/30)+1));
        }

        cell = row.getCell(Short.parseShort("4")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.tramite"));
        cell = row.getCell(Short.parseShort("5"));
        if(StringUtils.isNotEmpty(actasBean.getTramiteTxt())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE,Short.parseShort("5"),W83bClsConstantes.VEINTE,Short.parseShort("6")));//NOPMD
        	cell.setCellValue(actasBean.getTramiteTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.VEINTE,excel,wb));
        }else{
        	cell.setCellValue(actasBean.getTramiteTxt());
        }
        tamanyoTexto = actasBean.getTramiteTxt().length();
        if(18<tamanyoTexto&&(short)(22*(tamanyoTexto/30)+1)<(short)(22*(tamanyoTexto/24)+1)){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/24)+1));
        }

        
        cell = row.getCell(Short.parseShort("7")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fTramDH"));
        cell = row.getCell(Short.parseShort("8"));   
        StringBuffer fechaTramite = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(actasBean.getFechaTramiteDel())){
        	fechaTramite.append(actasBean.getFechaTramiteDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(actasBean.getFechaTramiteHasta())){
        	if(desde){
        		fechaTramite.append("-");
        	}
        	fechaTramite.append(actasBean.getFechaTramiteHasta());
        }
        cell.setCellValue(fechaTramite.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.VEINTE,excel,wb));
  
        String ultTramite = "";
        
        cell = row.getCell(Short.parseShort("9")); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.ultTramite"));
        cell = row.getCell(Short.parseShort("10"));   
        if(W83bClsConstantes.CONSTANTE_SI.equals(actasBean.getUltTramite())){
        	ultTramite = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else {
        	ultTramite = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);        	
        }        
        cell.setCellValue(ultTramite.toUpperCase());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.VEINTE,excel,wb));
        //FIN TRMITE
        
 
        //fin CONVENIOS

        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("23")); // Creacin de la fila 137
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nActa",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nActa",W83bClsConstantes.CONSTANTE_CASTELLANO)
        		);
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegistro",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegistro",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("2")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nPreaviso",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nPreaviso",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("3")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("5")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("6")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nCentro",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nCentro",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("7")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("8")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fEleccion",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fEleccion",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("9")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fComision",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fComision",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("10")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nElectores",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nElectores",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("11")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.baja",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.baja",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        if(null!=listaActas){
	        for(int i=0;i<listaActas.size();i++){
	        	row = sheet.createRow((short)24+i); // Creacin de la fila 1
	        	
	        	//Numero Acta
	        	cell = row.createCell(Short.parseShort("0")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getNumActa())){
	        		cell.setCellValue(((W83bActasBean)listaActas.get(i)).getNumActa());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("1")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getNumRegistro())
	        			&& StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getCodTerritorioActa())
	        		&& StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getAnyoReg())){
	        		String numReg = W83bUtilidades.rellenarCaracter(((W83bActasBean)listaActas.get(i)).getNumRegistro(), "0", 6, true);
	        		cell.setCellValue(((W83bActasBean)listaActas.get(i)).getCodTerritorioActa()+"/"+((W83bActasBean)listaActas.get(i)).getAnyoReg()+"/"+numReg);
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("2")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getNumPreaviso())){
	        		if(((W83bActasBean)listaActas.get(i)).getNumPreaviso().length()<9){
	        			cell.setCellValue("");
	        		}else{
	        			cell.setCellValue(((W83bActasBean)listaActas.get(i)).getNumPreaviso());	
	        		}
	        		
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("3")); 
	        	HSSFCell cell2 = row.createCell(Short.parseShort("4")); 
	        	//HSSFCell cell3 = row.createCell(Short.parseShort("6")); 
	        	sheet.addMergedRegion(new Region(24+i,Short.parseShort("3"),24+i,Short.parseShort("4")));//NOPMD 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getRazonSocial())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getRazonSocial()));
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	cell2.setCellStyle(estiloFila(i,excel));
	        	//cell3.setCellStyle(estiloFilaNoJustif(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("5"));
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getCifnif())){
	        		cell.setCellValue(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getCifnif());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("6")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getNumCentro())){
	        		cell.setCellValue(W83bUtilidades.numero(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getNumCentro()));
	        	}else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("7")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getMunicipio())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getMunicipio()));
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("8")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getFechaEleccion())){
	        		cell.setCellValue(((W83bActasBean)listaActas.get(i)).getFechaEleccion());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("9")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getFechaComision())){
	        		cell.setCellValue(((W83bActasBean)listaActas.get(i)).getFechaComision());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("10")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getElectoresTotal())){
	        		cell.setCellValue(W83bUtilidades.numero(((W83bActasBean)listaActas.get(i)).getElectoresTotal()));
	        	}
	        	cell.setCellStyle(estiloFilaNumero(i,excel));
	        	
	        	//Numero Registro
	        	cell = row.createCell(Short.parseShort("11")); 
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getBaja())){
	        		cell.setCellValue(((W83bActasBean)listaActas.get(i)).getBaja().toUpperCase());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	if(StringUtils.isNotEmpty(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getRazonSocial())){
		        	if(30<(((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getRazonSocial()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bActasBean)listaActas.get(i)).getCentroTrabajo().getRazonSocial()).length()/30)+1));
		        	}
	        	}
	        }
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoActas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}		
	}
	
	
	
	/**
	 * Estilo fila numero.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumero;
		}else{
			return excel.styleTextoImparNumero;			
		}
		
	}
	
	
	/**
	 * Estilo fila centro.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
	

}
